About the author and his system:

   Lee McEwen is a management analyst living in central New Jersey.  He has
been running public bulletin boards since 1985 but only established a CP/M
based system at the beginning of 1989.  Within three months, Socrates had
gained Z-Node status.  Lee dedicated Socrates to learning, whether it be the 
Z-System or high level languages.  There is a message base devoted to the
new 'C' programmer.  In addition, Socrates is the central site for QBBS 
development.

   Socrates can be called at (201) 754-9067, at up to 2400 bps.  It runs on
an Ampro Little Board with a 64 meg drive.  Lee runs on Coke and potato
chips.

=============================================================================

                            Using BYE with NZCOM
                                     or
                       The New Taming of an Old Shrew

                               by Lee McEwen
                            Socrates Z-Node #32

   Socrates, my rcpm, went on line last December.  Evidently, this was more
of an event than it seemed at the time.  Why?  I had just bought NZCOM the
week before, without any previous Z System experience, and getting BYE to 
peacefully coexist with NZCOM was supposed to be hard.  To be fair, mine 
wasn't the first rcpm to run under NZCOM.  Bob Dean converted Drexel Hill to 
NZCOM sometime the previous summer, and I am sure there were others.  But
the difference, I'm told, was that a total neophyte managed to stumble in
the right combinations to make things work.  This seemed to interest Jay
Sage, who surely is more accustomed to dealing with people who can walk and
chew gum at the same time!  He asked me to tell you how I did it.

   Before we start, I should mention one thing.  It is true that you can't
run NZCOM under BYE.  BYE is an RSX and protects itself from being
overwritten.  NZCOM is a very powerful loader that can reconfigure the
memory map.  It looks for such programs as BYE and refuses to run when they
exist.  But we don't need to run NZCOM while BYE is running.  We run it
before we run BYE, and we change systems with ENV files rather than ZCM,
using JetLDR.  Our only real restriction is that we cannot change the memory
map while BYE is active.

   In this article, we will set up a Xerox 16/8 DEM-II with a 10 meg hard
drive, which we have configured with three logical drives (A: through C:)
for the hard drive and one floppy as drive D:.  Here is a list of steps to
take which we will discuss in turn:

            Get NZCOM running first.
              RCP vs. Transient commands.
              Become familiar with ZCM files and how to edit them.
              Make your named directory files.
            Patch WHL.COM and NZCOM.COM
            Get BYE running next.
              Watch out! There some traps here.
              Z3BASE.LIB
    +-+-+-> Tweak it.
    | | |     Use MKZCM, NZCOM.COM and JETLDR.
    | | |     Current public DU:'s will reflect in the new .ZCM files.
    | | +-< Check SHOW, PATH and PUBLIC, and the BYE.PRN file.
    | |     Get your BBS software up and running.
    | +---< Make your aliases.
    |         My usual ones.
    |       Choose your transient commands carefully
    |         What stays on A0:
    |         What must be moved to A15:
    +-----< Check the system on line.
              Watch for security.


GET NZCOM RUNNING FIRST.

   Why NZCOM first?  It is your operating system.  Imagine trying to run a
program without having CP/M installed on your computer.  BYE is a nasty
program in that it hooks itself very deeply into the system.  Getting it
running under the wrong system is a waste of time.

   We want to get the memory configuration of NZCOM that you will use with
the BBS going.  If you need a certain sized TPA for your BBS, you have to
make room for it here since we can't change the memory map later while BYE
is  running.  Place MKZCM, SHOW, PATH, and PUBLIC and your favorite editor
on A0:.  Run MKZCM to create your 'on line system'.  We will be making
several versions of the system, but they must all have the same memory map.

   We will be setting up three systems.  The first is the one we will be
letting the callers use.  It will have significant restrictions set on it. 
Then we will set up a system for the sysop which will allow you to do
anything you like on your computer, but will lock out the floppy disk drive. 
Why do that?  What if you call in remotely and enter a command such as 'FF'
that accesses the floppy, but you forgot to leave a disk in the drive? 
You'd hang the system.  Finally, we'll make one last system the same as the
sysop's, but it will let you at the floppy.  I found it easier to set up the
restricted system first and then after that is running properly, go back and
set up the sysop systems.

   I installed an NZCOM system without any RCP.  As I implied in the lead 
paragraph, my assembly programming experience is less than minimal.  As a 
result, I trust transient commands much more than I do anything permanent in 
the operating system itself.  If a command doesn't behave as I expected, I 
replace it, or get it out of harm's way.  The book says that IOP's are a
topic for advanced users.  Well, that did that!  I dumped them as well.  I
then increased the number of named directories allowed.  And with that, I
saved my new system.  Use the name 'USER' to save this configuration.

   MKZCM will save two files, each of which describes the configuration
you've  just done.  USER.ZCM is of particular interest to us as it describes
the  target system in a text file which you can easily edit.  Let's do that
now.   Pay particular attention to MAXDRV, MAXUSR, QUIET, Z3WHL, DRVEC,
PUBDRV, and  PUBUSR.  Load up your editor and bring up USER.ZCM in non
document mode:

  EA06 CBIOS    0080 ENVTYP    E8F4 EXPATH    0005 EXPATHS   0000 RCP
  0000 RCPS     0000 IOP       0000 IOPS      E200 FCP       0005 FCPS
  E480 Z3NDIR   0023 Z3NDIRS   E900 Z3CL      00CB Z3CLS     E780 Z3ENV
  0002 Z3ENVS   E700 SHSTK     0004 SHSTKS    0020 SHSIZE    E880 Z3MSG
  E8D0 EXTFCB   E9D0 EXTSTK  ->0000 QUIET   ->E8FF Z3WHL     0004 SPEED
->0010 MAXDRV ->001F MAXUSR    0001 DUOK      0000 CRT       0000 PRT
  0050 COLS     0018 ROWS      0016 LINS    ->FFFF DRVEC     0000 SPAR1
  0050 PCOL     0042 PROW      003A PLIN      0001 FORM      0000 SPAR2
  0000 SPAR3    0000 SPAR4     0000 SPAR5     CB00 CCP       0010 CCPS
  D300 DOS      001C DOSS      E100 BIO     ->0001 PUBDRV  ->0080 PUBUSR

   This almost describes a Xerox 16/8 DEM-II computer, but it is wrong about
the drives we have.  Notice that MAXDRV is 0010, and DRVEC is FFFF.  These
two values say that we have 16 contiguous drives on the computer.  This is
not the case.  This system has four drives, but we are building a system for
public use, and we won't be letting the callers at our floppy drive.  We
need to change MAXDRV to 0003.  

   That's easy enough.  But what of this DRVEC?  It is a bit map of the
valid drives, which lets NZCOM skip over any drive that is not present.  You
can use the following chart to determine the value to give DRVEC.  Put a one
over any drive that you have on the system.  Add up the values for each
line, and write them down in hexadecimal to the right. 

                 Weight Factor:
               8    4    2    1

               0    0    0    0    =    0---
               P    O    N    M

               0    0    0    0    =    -0--
               L    K    J    I

               0    0    0    0    =    --0-
               H    G    F    E

               0    1    1    1    =    ---7
               D    C    B    A
                                        0007

Change DRVEC to 0007.

   We also want to limit the highest user area we will let the callers have 
access to.  All the sensitive commands such as ERA will be up high.  I have 
mine set at 7.  Change MAXUSR to 0007.

   The QUIET flag tells the system if it should report what it is doing to
the user.  We want this for ourselves, but not for our callers.  Part of our 
security is that we will be using aliases to load in modules which we will
be giving secret names.  If the quiet flag is off, the names will be
reported as they load.  So set QUIET to 0001.

   Take note of the value you have for Z3WHL.  You will want this later on
when  we get to BYE and save this file.

   But didn't we forget PUBDRV and PUBUSR?  These refer to the public drive
and user areas that ZRDOS will recognize, and are a bit of a bear.  On my
system, I have A8: set as a public DU: where I put WordStar.  Obviously we
don't want callers using that!  But every time I edited the USER.ZCM file to
say there were no public DU's, the next time I loaded the system, they'd be
back!  The trick here is to use the PUBLIC utility to cancel any public DU's
before you load your new system.  Do that now.

    Now enter 'NZCOM A0:USER.ZCM' to load this system.  Be sure you include
the prefix A0:.   Run SHOW to see if we have the values we want for the
drives and user areas.  You'll see this on screen 3.  Everything OK?  If
not, then go back to your editor and change USER.ZCM as needed.

   Run PATH to see if the QUIET flag is correct.  It won't tell you anything
if the QUIET flag is on.  If it tells you what your path is, then the QUIET
flag is off.  That's not good.  Again, load your editor, and fix QUIET.

   If you've changed anything, reload with NZCOM and check everything again
with SHOW and PATH.  Keep editing, reloading, and checking until you have it
the way you want it.

   Now check for PUBLIC DU's.  You should have none.  If you do have any,
clear them now.

   Run MKZCM one more time.  Don't change anything, just save it under the
same name.  Why do that?  Remember that MKZCM creates two files?  The one
we've been working with has the extension of 'ZCM'.  If you noticed, the
other file MKZCM saved had the extension of 'ENV'.  This is what we've been
after all this time because JetLDR can handle this file just fine.

   Check and recheck that the system is set as you'd want for open use. 
When you are happy with the users' system, we will go on to make the sysop
system.  Bring up MKZCM again, but this time save the result under a name
that only you will know.  For our discussion, we will call it SYSOP.  Let's
go back with your editor and give you some access on your own computer!

   Change MAXUSR to the maximum user area you have.  This is usually 15. 
Pull that DRVEC chart out again.  Check off all the drives you need access
to,  except for floppy disks.  Then set QUIET to 0000.  But watch out! 
Don't do anything that changes the size of the system.  Save the results.

   Enter 'NZCOM A0:SYSOP.ZCM' to load this system.  Again, it is important
to enter the A0:.  Run SHOW and PATH.  Is it set as you want?  If not, edit
again and reload.

   Now set any public DU's you want.  After you've thoroughly verified the 
settings, run MKZCM to create an ENV of this system.  Finally, create one
more system, but this time include the floppies.  Give this another secret
name.

   What have we done?  We've created three environment files that we can use
on-line to change a caller's access.  We don't need the ZCM files any
longer, so you can erase them.  Use STAT or DFA to set all the ENV files to
$SYS so that users will not be able to see them with the DIR command.

   The last thing to do before we move on is to create the named directory 
files.  I use the same names as the environment files.  The big point here
is that even if a DU: is out of range of the environment, if it has a name
and no password, a caller can move there.  You can give passwords to
directories, but it is simpler just to not declare them in the first place
if you don't want people going there.

   [Note by Jay Sage: I take a different approach and make extensive use of
named directories with passwords.  In fact, the named directories on my
system are the same for users and sysops.  All I do to make the sysop
systems is turn on the wheel byte, since when this is on, passwords are
ignored, and one has free access to all the sysop directories.]


PATCH WHL.COM AND NZCOM.COM

   Before we go too much further, you need to make two patches.  Make backup 
copies of NZCOM.COM.  If you dumped the RCP as I did, you need a transient 
called WHL32.COM to manipulate your wheel byte, and we will patch this as well.  If you are using the RCP, your system password is in there.  Big
point here is to do this after you've made back-up copies of whatever you
are going to patch.  Can you say 'oops'?

   Use DU (disk utility), ZPATCH, or whatever you are comfortable with and
call in NZCOM.COM.  Search for NZCPM.  This will be in the FCB section of
the program.  Change it to something else.  Your restrictions are that you
must make this eight characters or less, that you must pad it out to exactly
eight characters with spaces, and that you must use capital letters.  What
you put here must be a secret.

   Now, why did we do this?  NZCOM will make a file called NZCPM.COM on the
disk if there isn't already one.  The purpose of this file is to allow you
to dump the NZCOM system and go into straight CP/M.  If a user does this on
line, he will effectively turn your BBS off.  He can't hurt anything, as BYE
won't be able to talk to the system any longer, but it won't reset when he
finally drops carrier, either.  You'll be crashed until you reboot.

   So we gave NZCPM a secret name.  Drop out of NZCOM and reload it.  The
system will write NZCPM.COM under the name you just gave it.  Erase
NZCPM.COM, and use STAT to make its replacement a $SYS file so that no one
but you knows its name.

   [Note by Jay Sage:  Again, I can suggest an alternative and simpler
approach.  Leave NZCOM.COM as it is.  Run it to create the file NZCPM.COM,
and then copy that file to a secure area.  Then use SALIAS to create an
alias called NZCPM that has the script command: "IF WH;DIR:NZCPM;FI", where
DIR is the directory where you put the real NZCPM.COM.  The presence of this
alias will inhibit NZCOM from creating a new NZCPM file, and the alias will
do something only in sysop mode (when the wheel byte is on).  If the wheel
byte is off, the command will do nothing.  If the wheel is on, then the real
NZCPM command will be invoked.]

   The other patch we have to make is the wheel password.  If you dumped the
RCP as I suggested, then you will be using WHL32.COM.  Patch that. 
Otherwise you patch NZRCP.ZRL in NZCOM.LBR.  Look for either SYSTEM or
PASSWORD.  I forget what it says in the distribution copy.  Change it to
something else.  Again, your restrictions are eight characters, padded with
spaces, in capital letters.  [Note added by Jay Sage:  This patch you
absolutely must do; you must not leave a wheel-setting command on the system
with an unsecure password.  The wheel password is not determined by the
system but is set for each WHEEL program (e.g., WHL32 or the RCP WHL
command).  You should be able to find the password using a patching utility
and change it to something secret.  Be sure to test it before putting your
system on the air.]


GET BYE RUNNING NEXT

   Now comes some real fun.  Getting BYE running for the first time is
almost guaranteed to take five years off your life and is more that we can
tackle in one article.  I suggest you work closely with a Z-Node sysop for
assistance as you go.  But here is the plan: get BYE running any way you can
at first, and then go back to tweak it.  I would suggest you rename DIR to
the name of the BBS you plan to run so that it will be the program run when
you test BYE.  This eliminates any problems you may have with your BBS
system as you debug BYE itself.

   BYE is a necessary evil.  It hasn't been given a full rewrite in about
five years, and its age is showing.  The biggest problem is that it tries to
be all things for all systems.  All I want from BYE is modem redirection, a
few extra BDOS calls to handle situations that would only happen under a
remote system (such as time on line and carrier test), and maybe a few neat
function keys like "Who's on line?".  What I don't want it doing is messing
with the environment.  We have an operating system to do that for us. 
Unfortunately, BYE insists, and it usually messes things up.  One of these
days we will have a BYE made for today's systems.  Until then, we have to
work with this monster.  [Note added by Jay Sage:  See my column in TCJ #40
for a discussion of what BYE does.  I second Lee's comments about BYE and
the need for a replacement that is appropriate for Z-Systems.]

   I use QBYE, as it is the simplest to set up.  QBYE is based on NUBYE 1.01
by Tom Brady.  Tom and Irv Hoff had worked together for most of the
development of BYE but parted company just as the last generation came out. 
I would expect whatever findings I have with QBYE you will have with BYE
5.10.

   I noticed some very odd happenings at the OS level and suspected a
conflict between BYE and NZCOM.  There were two symptoms: the utilities that
check the DRVEC seemed to be pretty solid, but those that checked MAXDRV
were flaky.  For example, FF (Find File) would not report any files found on
the highest drive.  If I set the system to sysop access while a user was on
line, it acted strangely once I would reset back to normal access.  The only
solution was to allow the caller to have wheel privileges for the duration
of the call.

   Finally, I pulled SHOW down while a caller was on line to see what was
going on.  It seems that BYE was resetting the MAXDRV and MAXUSR bytes
erroneously.  On cold boot, it was giving MAXDRV one less drive than
allowed, and MAXUSR one more.  More importantly, once any new environments
were loaded, it put invalid data into these bytes.

   Though I had told BYE not to monitor the maximum DU: settings, it was 
insisting on doing just that.  Worse, it wasn't doing it right!  See Fig. 1
for the CCP settings in the BYE configuration file as used on Socrates.  Be
aware that ALL system security with these settings is now the purview of
NZCOM.  BYE will not monitor anything for you.  Carefully test your various
environment settings remotely before leaving the system for public calls. 
You should look through the PRN file to make sure the proper addresses are
being assigned, since the addresses will differ from system to system.

   You will notice reference to an include file named Z3BASE.LIB.  You will
have to generate such a file with definitions for the module addresses
referenced in BYE.  Fig. 2 shows the Z3BASE.LIB that I use.  You have to
edit this with your memory configuration before you assemble BYE.  Notes in
the file will explain.

   So now you have BYE running.  Go on-line and use SHOW to make sure the
system has stayed the way you want it to.  Use JetLDR to load the various 
environments we made up before and use SHOW to verify that MAXDRV, MAXUSR,
and DRVEC have stayed correct.  Then, turn your WHL on and off while you try 
wheel-dependent commands such as ERA.  The system should respond correctly.  
If you have problems, you need to edit either your Z3BASE or BYE again and 
reassemble.

   Once you have gotten this far, you are ready to install your BBS
software.  I use QBBS for a couple of reasons.  It holds messages from
different areas completely apart, and it is distributed with full source
code.  It doesn't hurt that QBBS is almost a snap to install.  What is taken
as a negative by many, that it is written in compiled BASIC, is a plus in my
mind.  What does a BBS program do?  Basically, it is a text file reader that
has to be capable of finding messages quickly.  Other than that, and the
message editor, a BBS program really isn't that involved.  I will put QBBS
up against PBBS and HBBS, both written in 100% machine code, in a speed test
any day of the week.  Also, modifying high level language programs is
usually easier.  But what you chose is up to you.


MAKE UP YOUR ALIASES

   As I said earlier, part of your system security is that the names you
give  your environment files must be a secret.  The only way to invoke them
with a caller on line is to blank out the modem output with BYE's ESC-B, or
to load them through an alias.  I use the alias method.  If you haven't
picked up on it by now, I don't trust BYE farther than I can throw it....

   Here are a couple of example aliases I have.  By the way, don't put these
into your ALIAS.CMD file.  I've seen various versions of TYPE that let users
type out a $SYS file, and that would blow the secret!

This is the alias to load the normal (secure) system.  It is named NZUSER:

	A0:NZUSER    --> ldr a0:user.env
	                 ldr a0:user.ndr
	                 whl <wheel password> /s
	                 path a0 $$$$ a0
	                 whl r
	                 echo system load done

Now the alias to load the sysop system:

	A0:NZSYSOP   --> if ~wh
                   	   whl /s
	                 fi
                 	 if wh
                   	   ldr a0:sysop.ndr
                   	   ldr a0:sysop.env
                   	   path a0 $$$$ a15 A0
                   	   echo sysop system loaded
                 	 else
                   	   echo access denied
                 	 fi

This alias gives the user a chance to set the wheel in case it is off, but
will abort if he can't get it set.

   Two questions.  First, why do we load the SYSOP.NDR before we load the
SYSOP.ENV?  Remember the QUIET flag?  If we reversed the order, the system
would report the name of our NDR file to the user.  Second, why do we load
the extended path after we load the environment?  Because if we didn't, A15:
would be an invalid DU:, and the system would refuse to allow a path to it.

   The alias to load the floppy system is the same as the sysop alias,
except it loads the floppy environment.

   The last of what I feel are the essential aliases is called BYE.  Why
would I do that?  Again, I don't trust the real BYE to handle system
security properly, so I have this alias reset the environment through the
NZUSER before calling the real BYE.  Of course, rename your real BYE to
something else, and make it a $SYS file:

	A0:BYE       --> echo one moment please.
	                 nzuser
	                 echo thank you for calling.
	                 echo please call again.
	                 realbye $*


CHOOSE YOUR TRANSIENTS

   You are very close to going on line.  Move MKZCM, SHOW, STAT, your
editor, and anything else that allows someone to fool with the system up to
a safe, high user area.  Most of us use A15: for this.  Set all the ENV and
NDR files to $SYS status, as well as all NZCOM files and libraries and the
aliases we made up.  Not only does this keep people from trying things they
shouldn't, it also keeps them from downloading them.  What good does it do
to go through all this to have someone download your NZCOM.LBR with its
patched wheel password?

   Time to choose your transient commands.  You will need something for file 
transfers.  I use ZMD150 and RZMP16.  Something to type out text files?  I
use ZLT12.  Something to lock into LBR and ARC files?  I have LUX77B, LUSH,
and ZLUX26, none of which I am really happy with.  Gotta work with ARC
files, like it or not, so that means you need UNARC16.  Don't forget LDIR,
and in today's world, ZIPDIR.  Does that about do it?


LET'S GO SEE THE WORLD

   If you've gotten this far, you're ready to start taking calls.  I suggest
you start by calling it yourself!  Thrash it, bash it, try to break it.  If
you can't, then it is time to tell a few friends.  Give them the same
assignment.  Have them do anything they can to crash the system.  If someone
can do it, eventually they will, and it might as well be now, done by a
friend who will tell you how it happened.  Leave the system private amongst
yourselves for a couple of weeks.  If it still works as it should after this
time, go public.  We will all welcome a new RCP/M.

Welcome to the club, sysop!


-----------------------------------------------------------------------------

; ++ CCP Options ++
;
ZCPR2   EQU     no              ; Yes, if running ZCPR/ZCMD/NZCPR (1 or 2)
;
; NOTE: Requires MAC.COM to assemble if ZCPR3 is set YES.
;
ZCPR3   EQU     yes             ; Yes, if running ZCPR3
;
         IF     ZCPR3
        MACLIB  Z3BASE          ; Requires MAC to assemble
         ENDIF
;
; NZCPR/ZCMD/ZCPR all use bytes (at 3DH/3EH/3FH) to store the maximum
; drive, wheel status, and maximum user area.  QBBS pokes these values
; in QBYE which in turn maintains them in low memory bytes.
;
USEZCPR EQU     yes             ; (QBBS = NO, except w/NZCOM. Then, YES)
;                               ;
CHEKDU  EQU     no              ; Yes, if QBYE will monitor MAXDRIV/USER.
                                ;   If using ZCPR/ZCMD/NZCPR, set this NO,
                                ;   since they already do it (saves a lot of
                                ;   code, too).  In either case, QBYE will
                                ;   have the correct values in MAXDRIV/USER.

;Set this equate to your system's ENV address:
NZENV   EQU     0E780h          ; Required for use with NZCOM
                                ; this value will vary on each computer.
                                ; use SHOW to see where your ENV is.
WHEEL   EQU     NZENV+17Fh      ; Location of ZCPR's wheel flag
MAXDRIV EQU     NZENV+02Ch      ; ZCPR location of MAXDRIV byte
MAXUSER EQU     NZENV+02Dh      ; ZCPR location of MAXUSR byte
;

MAXDRV  EQU     'J'             ; Highest drive supported
                                ; NZCOM:  Put this to highest + 1 on system 
                           	; and let the OS control access.
MAXUSR  EQU     15              ; Highest user area
                                ; NZCOM:  Put this to highest on system and
                                ; let the OS control access.
;
; In all cases, set SYSDRV/USR, since the ^B function gives you these
; d/u areas when used to toggle off the user temporarily.
;
;NZCOM:  Set SYSDRV to one more than you really want.

SYSDRV  EQU     'J'             ;#Highest local drive supported
SYSUSR  EQU     15              ;#Highest local user area (0-15)
;
                         -------------------------

Figure 1.  This is a section of the BYE configuration file showing the
proper settings to use on an NZCOM system.

-----------------------------------------------------------------------------

;Z3BASE.LIB
;
;Last edited: 10 July 89, Lee McEwen
;
;Currently configured for use with:
;  Ampro LB, 64 MB / NZCOM
;  Maximum memory size for use on bbs under bye
;
false   equ     0
true    equ     not false
off     equ     0
on      equ     not off

base    equ     0

;The following values are taken from screen 1 of SHOW:

z3cl    EQU     0DD00H                  ;mcl, multiple command line
z3cls   EQU     203                     ; length of mcl in bytes
expath  EQU     0DCF4H                  ;path
expaths EQU     5                       ; number of path elements
shstk   EQU     0DB00H                  ;shl, shell
shstks  EQU     4                       ; number of shell entries
shsize  EQU     32                      ; size of each shell entry
z3env   EQU     0DB80H                  ;env, z-system environment
z3envs  EQU     2                       ; size of env in records
z3msg   EQU     0DC80H                  ;msg, system message buffer
z3msgs  EQU     80                      ; size of msg in records
z3whl   EQU     0DCFFH                  ;whl, location of wheel byte
z3whls  EQU     1                       ; size of whl in bytes

                         -------------------------

Figure 2.  The part of the file Z3BASE.LIB needed for the assembly of BYE.

-----------------------------------------------------------------------------
            